
# heads50.py

import math, random
import matplotlib.pyplot as plt

NUM_ITERS = 100000
counts = [0]*51

probs = []
for n in range(51):
  # calculate prob of n heads
  prob = math.comb(50,n) / (2**50)
  # print(f"Prob {n} heads: {prob:.6f}")
  probs.append(prob)


for i in range(NUM_ITERS):
  tosses = random.choices(["head", "tail"], k=50)
  numHeads = tosses.count("head")
  counts[numHeads] += 1
probCounts = [ c/NUM_ITERS for c in counts] 

plt.plot(range(51), probs, '-o', label="binomial")
plt.bar(range(51), probCounts, width=0.5, alpha = 0.4, label="tosses")
plt.legend()
plt.show()

